<?php
if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED !== true) die();
global $APPLICATION;
$APPLICATION->AddHeadString('<link rel="stylesheet" href="/local/modules/rechecker.tools/css/shared.css">');
$proxyUrl = $arResult['API_PROXY_URL'];
$apiKeySet = $arResult['API_KEY_SET'];
?>
<?php if (!$apiKeySet): ?>
    <div class="meta-error" style="padding:16px;background:#fef2f2;border-radius:8px;color:#dc2626;">API ключ не настроен. Укажите ключ в настройках модуля rechecker.tools.</div>
<?php else: ?>
<div class="service-page__form">
    <div class="service-page__input-group">
        <input type="url" id="urlInput" class="service-page__input" placeholder="Введите URL страницы, например: https://example.com" />
        <button type="button" id="checkBtn" class="service-page__btn">Проверить</button>
    </div>
    <div id="results" class="service-page__results"></div>
</div>
<script>
document.addEventListener('DOMContentLoaded', function() {
    var urlInput = document.getElementById('urlInput');
    var checkBtn = document.getElementById('checkBtn');
    var results = document.getElementById('results');
    checkBtn.addEventListener('click', async function() {
        var url = urlInput.value.trim();
        if (!url) { results.innerHTML = '<div class="meta-error">Пожалуйста, введите URL</div>'; return; }
        if (!url.startsWith('http://') && !url.startsWith('https://')) url = 'https://' + url;
        checkBtn.disabled = true;
        results.innerHTML = '<div class="service-page__loading"><svg width="40" height="40" viewBox="0 0 24 24" fill="none" stroke="#F36049" stroke-width="2"><path d="M21 12a9 9 0 1 1-6.219-8.56"/></svg><div>Проверяем все ссылки на странице...<br><small style="color:#999;font-size:13px;">Это может занять 30–90 секунд</small></div></div>';
        try {
            const resp = await fetch('<?= htmlspecialchars($proxyUrl) ?>', {
                method: 'POST', headers: {'Content-Type': 'application/json'}, body: JSON.stringify({url: url})
            });
            const data = await resp.json();
            if (data.success && data.data) displayResults(data.data);
            else results.innerHTML = '<div class="meta-error">' + (data.error || 'Ошибка') + '</div>';
        } catch (e) { results.innerHTML = '<div class="meta-error">Ошибка соединения: ' + e.message + '</div>'; }
        finally { checkBtn.disabled = false; }
    });
    urlInput.addEventListener('keypress', function(e) { if (e.key === 'Enter') checkBtn.click(); });
    function renderTag(name, value) {
        var isEmpty = !value || value === '—';
        return '<div class="meta-tag'+(isEmpty?' meta-tag--empty':'')+'"><div class="meta-tag__name">'+name+'</div><div class="meta-tag__value">'+(value||'—')+'</div></div>';
    }
    function displayResults(data) {
        var totalChecked=data.totalChecked, broken=data.broken, ok=data.ok, internal=data.internal, external=data.external, brokenLinks=data.brokenLinks, recommendations=data.recommendations;
        var html = '<div class="meta-results">';
        html += '<div class="meta-section"><h3 class="meta-section__title">Сводная статистика</h3><div class="meta-stats">';
        html += '<div class="meta-stat"><span class="meta-stat__value">'+(totalChecked !== undefined ? totalChecked : '—')+'</span><span class="meta-stat__label">Проверено</span></div>';
        html += '<div class="meta-stat"><span class="meta-stat__value" style="color:'+(broken > 0 ? '#dc3545' : '#28a745')+'">'+(broken !== undefined ? broken : '—')+'</span><span class="meta-stat__label">Битых</span></div>';
        html += '<div class="meta-stat"><span class="meta-stat__value" style="color:#28a745">'+(ok !== undefined ? ok : '—')+'</span><span class="meta-stat__label">Рабочих</span></div>';
        if (internal !== undefined) html += '<div class="meta-stat"><span class="meta-stat__value">'+internal+'</span><span class="meta-stat__label">Внутренних</span></div>';
        if (external !== undefined) html += '<div class="meta-stat"><span class="meta-stat__value">'+external+'</span><span class="meta-stat__label">Внешних</span></div>';
        html += '</div></div>';
        if (brokenLinks && brokenLinks.length > 0) {
            html += '<div class="meta-section meta-section--recommendations"><h3 class="meta-section__title">Битые ссылки ('+brokenLinks.length+')</h3><div style="overflow-x:auto;">';
            html += '<table style="width:100%;border-collapse:collapse;font-size:14px;"><thead><tr style="background:rgba(0,0,0,0.05);"><th style="padding:10px 12px;text-align:left;font-weight:600;color:#323036;">URL</th><th style="padding:10px 12px;text-align:center;font-weight:600;color:#323036;white-space:nowrap;">Статус</th></tr></thead><tbody>';
            brokenLinks.forEach(function(link, i) {
                var bg = i % 2 === 0 ? '#fff' : 'rgba(255,255,255,0.5)';
                var statusColor = link.ok ? '#28a745' : '#dc3545';
                var statusText = link.status ? link.status : (link.error ? 'Ошибка' : '—');
                html += '<tr style="background:'+bg+'"><td style="padding:10px 12px;word-break:break-all;color:#495057;">'+(link.url||'—')+'</td><td style="padding:10px 12px;text-align:center;font-weight:600;color:'+statusColor+';white-space:nowrap;">'+statusText+'</td></tr>';
            });
            html += '</tbody></table></div></div>';
        } else if (broken === 0) {
            html += '<div class="meta-section meta-section--success"><h3 class="meta-section__title">Отлично!</h3><p>Битых ссылок не обнаружено. Все ссылки на странице работают корректно.</p></div>';
        }
        if (recommendations && recommendations.length > 0) {
            html += '<div class="meta-section meta-section--recommendations"><h3 class="meta-section__title">Рекомендации</h3><ul class="meta-recommendations">';
            recommendations.forEach(function(r) { html += '<li>'+r+'</li>'; });
            html += '</ul></div>';
        }
        html += '</div>';
        results.innerHTML = html;
    }
});
</script>
<?php endif; ?>
