<?php
if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED !== true) die();
global $APPLICATION;
$APPLICATION->AddHeadString('<link rel="stylesheet" href="/local/modules/rechecker.tools/css/shared.css">');
$proxyUrl = $arResult['API_PROXY_URL'];
$apiKeySet = $arResult['API_KEY_SET'];
?>
<?php if (!$apiKeySet): ?>
    <div class="meta-error" style="padding:16px;background:#fef2f2;border-radius:8px;color:#dc2626;">API ключ не настроен. Укажите ключ в настройках модуля rechecker.tools.</div>
<?php else: ?>
<div class="service-page__form">
    <div class="service-page__input-group">
        <input type="url" id="urlInput" class="service-page__input" placeholder="Введите URL, например: https://example.com" />
        <button type="button" id="checkBtn" class="service-page__btn">Проверить</button>
    </div>
    <div id="results" class="service-page__results"></div>
</div>
<script>
document.addEventListener('DOMContentLoaded', function() {
    var urlInput = document.getElementById('urlInput');
    var checkBtn = document.getElementById('checkBtn');
    var results = document.getElementById('results');
    checkBtn.addEventListener('click', async function() {
        var url = urlInput.value.trim();
        if (!url) { results.innerHTML = '<div class="meta-error">Пожалуйста, введите URL</div>'; return; }
        if (!url.startsWith('http://') && !url.startsWith('https://')) url = 'https://' + url;
        checkBtn.disabled = true;
        results.innerHTML = '<div class="service-page__loading"><svg width="40" height="40" viewBox="0 0 24 24" fill="none" stroke="#F36049" stroke-width="2"><path d="M21 12a9 9 0 1 1-6.219-8.56"/></svg><div>Анализируем заголовки безопасности...</div></div>';
        try {
            const resp = await fetch('<?= htmlspecialchars($proxyUrl) ?>', {
                method: 'POST', headers: {'Content-Type': 'application/json'}, body: JSON.stringify({url: url})
            });
            const data = await resp.json();
            if (data.success && data.data) displayResults(data.data);
            else results.innerHTML = '<div class="meta-error">' + (data.error || 'Ошибка') + '</div>';
        } catch (e) { results.innerHTML = '<div class="meta-error">Ошибка соединения: ' + e.message + '</div>'; }
        finally { checkBtn.disabled = false; }
    });
    urlInput.addEventListener('keypress', function(e) { if (e.key === 'Enter') checkBtn.click(); });
    function gradeColor(grade) {
        if (grade === 'A+' || grade === 'A') return '#27ae60';
        if (grade === 'B' || grade === 'C') return '#f39c12';
        return '#e74c3c';
    }
    function statusBadge(status) {
        var map = { good: ['✓ Хорошо', '#27ae60'], warning: ['⚠ Предупреждение', '#f39c12'], missing: ['✗ Отсутствует', '#e74c3c'], bad: ['✗ Плохо', '#e74c3c'] };
        var item = map[status] || ['—', '#999'];
        return '<span style="display:inline-block;padding:2px 8px;border-radius:4px;background:'+item[1]+'20;color:'+item[1]+';font-size:12px;font-weight:600;">'+item[0]+'</span>';
    }
    function displayResults(data) {
        var grade=data.grade, score=data.score, headers=data.headers, recommendations=data.recommendations;
        var html = '<div class="meta-results">';
        html += '<div class="meta-section" style="text-align:center;padding:30px 20px;">';
        html += '<div style="font-size:72px;font-weight:900;line-height:1;color:'+gradeColor(grade)+';margin-bottom:8px;">'+grade+'</div>';
        html += '<div style="font-size:16px;color:#666;">Оценка безопасности HTTP заголовков</div>';
        html += '<div style="font-size:14px;color:#999;margin-top:4px;">Баллов: '+score+'/100</div>';
        html += '</div>';
        html += '<div class="meta-section"><h3 class="meta-section__title">Заголовки безопасности</h3>';
        headers.forEach(function(h) {
            html += '<div class="meta-tag"><div style="display:flex;align-items:center;justify-content:space-between;margin-bottom:6px;"><div class="meta-tag__name" style="margin-bottom:0;">'+h.name+'</div>'+statusBadge(h.status)+'</div>';
            html += '<div class="meta-tag__value" style="font-size:13px;color:#666;">'+h.description+'</div>';
            if (h.value) html += '<div style="margin-top:6px;font-size:12px;font-family:monospace;background:#f5f5f5;padding:4px 8px;border-radius:4px;word-break:break-all;">'+h.value+'</div>';
            html += '</div>';
        });
        html += '</div>';
        if (recommendations && recommendations.length > 0) {
            html += '<div class="meta-section meta-section--recommendations"><h3 class="meta-section__title">Рекомендации</h3><ul class="meta-recommendations">';
            recommendations.forEach(function(r) { if (r) html += '<li>'+r+'</li>'; });
            html += '</ul></div>';
        } else {
            html += '<div class="meta-section meta-section--success"><h3 class="meta-section__title">Отлично!</h3><p>Заголовки безопасности настроены хорошо.</p></div>';
        }
        html += '</div>';
        results.innerHTML = html;
    }
});
</script>
<?php endif; ?>
