<?php
if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED !== true) die();

// Проверяем установлен ли модуль
if (!CModule::IncludeModule('rechecker.tools')) {
    ShowError('Модуль rechecker.tools не установлен');
    return;
}

// Параметры компонента
$arParams = array_merge([
    'TITLE' => 'Проверка мета-тегов',
    'SHOW_FAQ' => 'Y',
    'SHOW_CTA' => 'Y',
    'API_KEY' => '', // Если пусто — берётся из настроек модуля
], $arParams);

// Получаем API ключ
$apiKey = $arParams['API_KEY'] ?: COption::GetOptionString('rechecker.tools', 'api_key', '');

$arResult = [
    'TITLE' => $arParams['TITLE'],
    'SHOW_FAQ' => $arParams['SHOW_FAQ'] === 'Y',
    'SHOW_CTA' => $arParams['SHOW_CTA'] === 'Y',
    'API_KEY_SET' => !empty($apiKey),
    'ENDPOINT' => 'meta-tags',
    'API_PROXY_URL' => '/local/components/rechecker.tools/meta-tags/proxy.php',
];

$this->IncludeComponentTemplate();
