<?php
if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED !== true) die();
global $APPLICATION;
$APPLICATION->AddHeadString('<link rel="stylesheet" href="/local/modules/rechecker.tools/css/shared.css">');
$proxyUrl = $arResult['API_PROXY_URL'];
$apiKeySet = $arResult['API_KEY_SET'];
?>
<?php if (!$apiKeySet): ?>
    <div class="meta-error" style="padding:16px;background:#fef2f2;border-radius:8px;color:#dc2626;">API ключ не настроен. Укажите ключ в настройках модуля rechecker.tools.</div>
<?php else: ?>
<div class="service-page__form">
    <div class="service-page__input-group">
        <input type="url" id="urlInput" class="service-page__input" placeholder="Введите URL, например: https://example.com/page" />
        <button type="button" id="checkBtn" class="service-page__btn">Проверить</button>
    </div>
    <div id="results" class="service-page__results"></div>
</div>
<script>
document.addEventListener('DOMContentLoaded', function() {
    var urlInput = document.getElementById('urlInput');
    var checkBtn = document.getElementById('checkBtn');
    var results = document.getElementById('results');
    checkBtn.addEventListener('click', async function() {
        var url = urlInput.value.trim();
        if (!url) { results.innerHTML = '<div class="meta-error">Пожалуйста, введите URL</div>'; return; }
        if (!url.startsWith('http://') && !url.startsWith('https://')) url = 'https://' + url;
        checkBtn.disabled = true;
        results.innerHTML = '<div class="service-page__loading"><svg width="40" height="40" viewBox="0 0 24 24" fill="none" stroke="#F36049" stroke-width="2"><path d="M21 12a9 9 0 1 1-6.219-8.56"/></svg><div>Проверяем цепочку редиректов...</div></div>';
        try {
            const resp = await fetch('<?= htmlspecialchars($proxyUrl) ?>', {
                method: 'POST', headers: {'Content-Type': 'application/json'}, body: JSON.stringify({url: url})
            });
            const data = await resp.json();
            if (data.success && data.data) displayResults(data.data);
            else results.innerHTML = '<div class="meta-error">' + (data.error || 'Ошибка') + '</div>';
        } catch (e) { results.innerHTML = '<div class="meta-error">Ошибка соединения: ' + e.message + '</div>'; }
        finally { checkBtn.disabled = false; }
    });
    urlInput.addEventListener('keypress', function(e) { if (e.key === 'Enter') checkBtn.click(); });
    function displayResults(data) {
        var html = '<div class="meta-results">';
        if (data.redirects && data.redirects.length > 0) {
            html += '<div class="meta-section"><h3 class="meta-section__title">Цепочка редиректов</h3>';
            data.redirects.forEach(function(redirect) {
                var statusClass = 'redirect-item__status--error';
                if (redirect.status === 301) statusClass = 'redirect-item__status--301';
                else if (redirect.status === 302 || redirect.status === 307 || redirect.status === 308) statusClass = 'redirect-item__status--302';
                else if (redirect.status === 200) statusClass = 'redirect-item__status--200';
                html += '<div class="redirect-item"><span class="redirect-item__status '+statusClass+'">'+redirect.status+'</span><span class="redirect-item__url">'+redirect.url+'</span></div>';
            });
            html += '</div>';
        }
        html += '<div class="meta-section">';
        if (data.totalRedirects > 0) {
            html += '<div class="redirect-summary"><div class="redirect-summary__title">Найдено редиректов: '+data.totalRedirects+'</div><div class="redirect-summary__url">Финальный URL: '+data.finalUrl+'</div></div>';
        } else {
            html += '<div class="redirect-summary"><div class="redirect-summary__title">Редиректов не найдено</div><div class="redirect-summary__url">URL отвечает напрямую: '+data.finalUrl+'</div></div>';
        }
        html += '</div></div>';
        results.innerHTML = html;
    }
});
</script>
<?php endif; ?>
