<?php
if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED !== true) die();
global $APPLICATION;
$APPLICATION->AddHeadString('<link rel="stylesheet" href="/local/modules/rechecker.tools/css/shared.css">');
$proxyUrl = $arResult['API_PROXY_URL'];
$apiKeySet = $arResult['API_KEY_SET'];
?>
<?php if (!$apiKeySet): ?>
    <div class="meta-error" style="padding:16px;background:#fef2f2;border-radius:8px;color:#dc2626;">API ключ не настроен. Укажите ключ в настройках модуля rechecker.tools.</div>
<?php else: ?>
<div class="service-page__form">
    <div class="service-page__input-group">
        <input type="url" id="urlInput" class="service-page__input" placeholder="Введите URL сайта, например: https://example.com" />
        <button type="button" id="checkBtn" class="service-page__btn">Проверить</button>
    </div>
    <div id="results" class="service-page__results"></div>
</div>
<script>
document.addEventListener('DOMContentLoaded', function() {
    var urlInput = document.getElementById('urlInput');
    var checkBtn = document.getElementById('checkBtn');
    var results = document.getElementById('results');
    checkBtn.addEventListener('click', async function() {
        var url = urlInput.value.trim();
        if (!url) { results.innerHTML = '<div class="meta-error">Пожалуйста, введите URL сайта</div>'; return; }
        if (!url.startsWith('http://') && !url.startsWith('https://')) url = 'https://' + url;
        checkBtn.disabled = true;
        results.innerHTML = '<div class="service-page__loading"><svg width="40" height="40" viewBox="0 0 24 24" fill="none" stroke="#F36049" stroke-width="2"><path d="M21 12a9 9 0 1 1-6.219-8.56"/></svg><div>Анализируем robots.txt...</div></div>';
        try {
            const resp = await fetch('<?= htmlspecialchars($proxyUrl) ?>', {
                method: 'POST', headers: {'Content-Type': 'application/json'}, body: JSON.stringify({url: url})
            });
            const data = await resp.json();
            if (data.success && data.data) displayResults(data.data);
            else results.innerHTML = '<div class="meta-error">' + (data.error || 'Ошибка') + '</div>';
        } catch (e) { results.innerHTML = '<div class="meta-error">Ошибка соединения: ' + e.message + '</div>'; }
        finally { checkBtn.disabled = false; }
    });
    urlInput.addEventListener('keypress', function(e) { if (e.key === 'Enter') checkBtn.click(); });
    function escHtml(str) { return String(str||'').replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;').replace(/"/g,'&quot;'); }
    function renderTag(name, value) {
        var isEmpty = !value || value === '—';
        return '<div class="meta-tag'+(isEmpty?' meta-tag--empty':'')+'"><div class="meta-tag__name">'+name+'</div><div class="meta-tag__value">'+(value||'—')+'</div></div>';
    }
    function displayResults(data) {
        var exists=data.exists, url=data.url, content=data.content, size=data.size, lines=data.lines, analysis=data.analysis, recommendations=data.recommendations;
        var html = '<div class="meta-results">';
        html += '<div class="meta-section"><h3 class="meta-section__title">Информация о файле</h3>';
        html += renderTag('Файл найден', exists ? 'Да' : 'Нет');
        if (url) html += renderTag('URL файла', url);
        if (size !== undefined) html += renderTag('Размер файла', size + ' байт');
        if (lines !== undefined) html += renderTag('Количество строк', lines);
        html += '</div>';
        if (analysis) {
            html += '<div class="meta-section"><h3 class="meta-section__title">Анализ директив</h3>';
            if (analysis.userAgents && analysis.userAgents.length > 0) html += renderTag('User-agents', analysis.userAgents.join(', '));
            if (analysis.disallowRules !== undefined) html += renderTag('Правил Disallow', analysis.disallowRules.length !== undefined ? analysis.disallowRules.length : analysis.disallowRules);
            if (analysis.allowRules !== undefined) html += renderTag('Правил Allow', analysis.allowRules.length !== undefined ? analysis.allowRules.length : analysis.allowRules);
            if (analysis.crawlDelay != null) html += renderTag('Crawl-delay', analysis.crawlDelay + ' сек.');
            if (analysis.sitemaps && analysis.sitemaps.length > 0) {
                html += '<div class="meta-tag"><div class="meta-tag__name">Sitemap</div>';
                analysis.sitemaps.forEach(function(sm) { html += '<div class="meta-tag__value" style="margin-bottom:4px;">'+escHtml(sm)+'</div>'; });
                html += '</div>';
            } else html += renderTag('Sitemap', '—');
            html += '</div>';
        }
        if (content) {
            html += '<div class="meta-section"><h3 class="meta-section__title">Содержимое файла</h3>';
            html += '<pre style="background:#f8f9fa;border-radius:8px;padding:16px;overflow-x:auto;font-size:13px;line-height:1.6;color:#323036;margin:0;white-space:pre-wrap;word-break:break-all;">'+escHtml(content)+'</pre>';
            html += '</div>';
        }
        if (recommendations && recommendations.length > 0) {
            html += '<div class="meta-section meta-section--recommendations"><h3 class="meta-section__title">Рекомендации по улучшению</h3><ul class="meta-recommendations">';
            recommendations.forEach(function(r) { html += '<li>'+escHtml(r)+'</li>'; });
            html += '</ul></div>';
        } else if (exists) {
            html += '<div class="meta-section meta-section--success"><h3 class="meta-section__title">Отлично!</h3><p>Файл robots.txt настроен корректно.</p></div>';
        }
        html += '</div>';
        results.innerHTML = html;
    }
});
</script>
<?php endif; ?>
