<?php
define('NO_KEEP_STATISTIC', true);
define('BX_BUFFER_RETURN', true);
define('NO_AGENT_STATISTIC', true);
require_once $_SERVER['DOCUMENT_ROOT'] . '/bitrix/modules/main/include/prolog_before.php';
header('Content-Type: application/json; charset=utf-8');
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Method not allowed']);
    die();
}
if (!CModule::IncludeModule('rechecker.tools')) {
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'Module not installed']);
    die();
}
$input = json_decode(file_get_contents('php://input'), true);
if (empty($input['url'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => 'URL не указан']);
    die();
}
$url = filter_var($input['url'], FILTER_SANITIZE_URL);
$apiKey = COption::GetOptionString('rechecker.tools', 'api_key', '');
if (empty($apiKey)) {
    http_response_code(503);
    echo json_encode(['success' => false, 'error' => 'API ключ не настроен']);
    die();
}
$client = new \Rechecker\Tools\ApiClient($apiKey);
$result = $client->checkSitemap($url);
echo json_encode($result, JSON_UNESCAPED_UNICODE);
die();
