<?php
if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED !== true) die();
global $APPLICATION;
$APPLICATION->AddHeadString('<link rel="stylesheet" href="/local/modules/rechecker.tools/css/shared.css">');
$proxyUrl = $arResult['API_PROXY_URL'];
$apiKeySet = $arResult['API_KEY_SET'];
?>
<?php if (!$apiKeySet): ?>
    <div class="meta-error" style="padding:16px;background:#fef2f2;border-radius:8px;color:#dc2626;">API ключ не настроен. Укажите ключ в настройках модуля rechecker.tools.</div>
<?php else: ?>
<div class="service-page__form">
    <div class="service-page__input-group">
        <input type="url" id="urlInput" class="service-page__input" placeholder="Введите URL сайта, например: https://example.com" />
        <button type="button" id="checkBtn" class="service-page__btn">Проверить</button>
    </div>
    <div id="results" class="service-page__results"></div>
</div>
<script>
document.addEventListener('DOMContentLoaded', function() {
    var urlInput = document.getElementById('urlInput');
    var checkBtn = document.getElementById('checkBtn');
    var results = document.getElementById('results');
    checkBtn.addEventListener('click', async function() {
        var url = urlInput.value.trim();
        if (!url) { results.innerHTML = '<div class="meta-error">Пожалуйста, введите URL сайта</div>'; return; }
        if (!url.startsWith('http://') && !url.startsWith('https://')) url = 'https://' + url;
        checkBtn.disabled = true;
        results.innerHTML = '<div class="service-page__loading"><svg width="40" height="40" viewBox="0 0 24 24" fill="none" stroke="#F36049" stroke-width="2"><path d="M21 12a9 9 0 1 1-6.219-8.56"/></svg><div>Проверяем sitemap.xml...</div></div>';
        try {
            const resp = await fetch('<?= htmlspecialchars($proxyUrl) ?>', {
                method: 'POST', headers: {'Content-Type': 'application/json'}, body: JSON.stringify({url: url})
            });
            const data = await resp.json();
            if (data.success && data.data) displayResults(data.data);
            else results.innerHTML = '<div class="meta-error">' + (data.error || 'Ошибка') + '</div>';
        } catch (e) { results.innerHTML = '<div class="meta-error">Ошибка соединения: ' + e.message + '</div>'; }
        finally { checkBtn.disabled = false; }
    });
    urlInput.addEventListener('keypress', function(e) { if (e.key === 'Enter') checkBtn.click(); });
    function renderTag(name, value) {
        var isEmpty = !value || value === '—';
        return '<div class="meta-tag'+(isEmpty?' meta-tag--empty':'')+'"><div class="meta-tag__name">'+name+'</div><div class="meta-tag__value">'+(value||'—')+'</div></div>';
    }
    function displayResults(data) {
        var exists=data.exists, url=data.url, urlCount=data.urlCount, sitemapCount=data.sitemapCount, isIndex=data.isIndex, sampleUrls=data.sampleUrls, recommendations=data.recommendations;
        var html = '<div class="meta-results">';
        html += '<div class="meta-section"><h3 class="meta-section__title">Информация о Sitemap</h3>';
        html += renderTag('Sitemap найден', exists ? 'Да' : 'Нет');
        if (url) html += renderTag('URL файла', url);
        html += renderTag('Тип файла', isIndex ? 'Sitemap Index (несколько файлов)' : 'Обычный Sitemap');
        html += '</div>';
        html += '<div class="meta-section"><h3 class="meta-section__title">Статистика</h3><div class="meta-stats">';
        html += '<div class="meta-stat"><span class="meta-stat__value">'+(urlCount !== undefined ? urlCount : '—')+'</span><span class="meta-stat__label">URL в Sitemap</span></div>';
        if (sitemapCount !== undefined) html += '<div class="meta-stat"><span class="meta-stat__value">'+sitemapCount+'</span><span class="meta-stat__label">Файлов Sitemap</span></div>';
        html += '</div></div>';
        if (sampleUrls && sampleUrls.length > 0) {
            html += '<div class="meta-section"><h3 class="meta-section__title">Примеры URL из Sitemap</h3>';
            sampleUrls.forEach(function(sampleUrl) {
                html += '<div class="meta-tag"><div class="meta-tag__value" style="word-break:break-all;">'+sampleUrl+'</div></div>';
            });
            html += '</div>';
        }
        if (recommendations && recommendations.length > 0) {
            html += '<div class="meta-section meta-section--recommendations"><h3 class="meta-section__title">Рекомендации по улучшению</h3><ul class="meta-recommendations">';
            recommendations.forEach(function(r) { html += '<li>'+r+'</li>'; });
            html += '</ul></div>';
        } else if (exists) {
            html += '<div class="meta-section meta-section--success"><h3 class="meta-section__title">Отлично!</h3><p>Sitemap XML настроен корректно и доступен для поисковых роботов.</p></div>';
        }
        html += '</div>';
        results.innerHTML = html;
    }
});
</script>
<?php endif; ?>
