<?php
if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED !== true) die();
global $APPLICATION;
$APPLICATION->AddHeadString('<link rel="stylesheet" href="/local/modules/rechecker.tools/css/shared.css">');
$proxyUrl = $arResult['API_PROXY_URL'];
$apiKeySet = $arResult['API_KEY_SET'];
?>
<?php if (!$apiKeySet): ?>
    <div class="meta-error" style="padding:16px;background:#fef2f2;border-radius:8px;color:#dc2626;">API ключ не настроен. Укажите ключ в настройках модуля rechecker.tools.</div>
<?php else: ?>
<div class="service-page__form">
    <div class="service-page__input-group">
        <input type="url" id="urlInput" class="service-page__input" placeholder="Введите URL сайта, например: https://example.com" />
        <button type="button" id="checkBtn" class="service-page__btn">Проверить</button>
    </div>
    <div id="results" class="service-page__results"></div>
</div>
<script>
document.addEventListener('DOMContentLoaded', function() {
    var urlInput = document.getElementById('urlInput');
    var checkBtn = document.getElementById('checkBtn');
    var results = document.getElementById('results');
    checkBtn.addEventListener('click', async function() {
        var url = urlInput.value.trim();
        if (!url) { results.innerHTML = '<div class="meta-error">Пожалуйста, введите URL сайта</div>'; return; }
        if (!url.startsWith('http://') && !url.startsWith('https://')) url = 'https://' + url;
        checkBtn.disabled = true;
        results.innerHTML = '<div class="service-page__loading"><svg width="40" height="40" viewBox="0 0 24 24" fill="none" stroke="#F36049" stroke-width="2"><path d="M21 12a9 9 0 1 1-6.219-8.56"/></svg><div>Проверяем SSL-сертификат...</div></div>';
        try {
            const resp = await fetch('<?= htmlspecialchars($proxyUrl) ?>', {
                method: 'POST', headers: {'Content-Type': 'application/json'}, body: JSON.stringify({url: url})
            });
            const data = await resp.json();
            if (data.success && data.data) displayResults(data.data);
            else results.innerHTML = '<div class="meta-error">' + (data.error || 'Ошибка') + '</div>';
        } catch (e) { results.innerHTML = '<div class="meta-error">Ошибка соединения: ' + e.message + '</div>'; }
        finally { checkBtn.disabled = false; }
    });
    urlInput.addEventListener('keypress', function(e) { if (e.key === 'Enter') checkBtn.click(); });
    function gradeClass(grade) {
        if (grade === 'A+' || grade === 'A') return 'color:#27ae60';
        if (grade === 'B' || grade === 'C') return 'color:#f39c12';
        return 'color:#e74c3c';
    }
    function formatDate(dateStr) {
        if (!dateStr) return '—';
        try { return new Date(dateStr).toLocaleDateString('ru-RU', {day:'numeric', month:'long', year:'numeric'}); }
        catch(e) { return dateStr; }
    }
    function renderTag(name, value) {
        var isEmpty = !value || value === '—';
        return '<div class="meta-tag'+(isEmpty?' meta-tag--empty':'')+'"><div class="meta-tag__name">'+name+'</div><div class="meta-tag__value">'+(value||'—')+'</div></div>';
    }
    function displayResults(data) {
        var ssl=data.ssl, hostname=data.hostname, grade=data.grade, recommendations=data.recommendations;
        var html = '<div class="meta-results">';
        html += '<div class="meta-section" style="text-align:center;padding:30px 20px;">';
        html += '<div style="font-size:72px;font-weight:900;line-height:1;margin-bottom:8px;'+gradeClass(grade)+'">'+grade+'</div>';
        html += '<div style="font-size:16px;color:#666;">Оценка безопасности SSL</div>';
        html += '<div style="font-size:14px;color:#999;margin-top:4px;">'+hostname+'</div>';
        html += '</div>';
        html += '<div class="meta-section"><h3 class="meta-section__title">Информация о сертификате</h3>';
        html += renderTag('Статус', ssl.valid ? 'Действителен' : 'Недействителен / отсутствует');
        html += renderTag('Протокол', ssl.protocol || '—');
        html += renderTag('Действителен с', formatDate(ssl.validFrom));
        html += renderTag('Действителен до', formatDate(ssl.validTo));
        html += renderTag('Дней до истечения', ssl.isExpired ? 'Истёк' : (ssl.isExpiringSoon ? '⚠️ '+ssl.daysRemaining+' дней' : ssl.daysRemaining+' дней'));
        html += renderTag('Шифр', ssl.cipher || '—');
        html += '</div>';
        html += '<div class="meta-section"><h3 class="meta-section__title">Издатель и субъект</h3>';
        html += renderTag('Издатель (CN)', (ssl.issuer && ssl.issuer.commonName) || '—');
        html += renderTag('Организация', (ssl.issuer && ssl.issuer.organization) || '—');
        html += renderTag('Домен (CN)', (ssl.subject && ssl.subject.commonName) || '—');
        if (ssl.subject && ssl.subject.altNames && ssl.subject.altNames.length > 0) {
            var altNames = ssl.subject.altNames.slice(0, 5).join(', ') + (ssl.subject.altNames.length > 5 ? ' и ещё '+(ssl.subject.altNames.length - 5) : '');
            html += renderTag('Alt домены', altNames);
        }
        html += '</div>';
        if (recommendations && recommendations.length > 0) {
            html += '<div class="meta-section meta-section--recommendations"><h3 class="meta-section__title">Рекомендации</h3><ul class="meta-recommendations">';
            recommendations.forEach(function(r) { html += '<li>'+r+'</li>'; });
            html += '</ul></div>';
        } else if (ssl.valid) {
            html += '<div class="meta-section meta-section--success"><h3 class="meta-section__title">Всё в порядке!</h3><p>SSL-сертификат действителен и настроен корректно.</p></div>';
        }
        html += '</div>';
        results.innerHTML = html;
    }
});
</script>
<?php endif; ?>
