<?php
if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED !== true) die();
global $APPLICATION;
$APPLICATION->AddHeadString('<link rel="stylesheet" href="/local/modules/rechecker.tools/css/shared.css">');
$proxyUrl = $arResult['API_PROXY_URL'];
$apiKeySet = $arResult['API_KEY_SET'];
?>
<?php if (!$apiKeySet): ?>
    <div class="meta-error" style="padding:16px;background:#fef2f2;border-radius:8px;color:#dc2626;">API ключ не настроен. Укажите ключ в настройках модуля rechecker.tools.</div>
<?php else: ?>
<div class="service-page__form">
    <div class="service-page__input-group">
        <input type="url" id="urlInput" class="service-page__input" placeholder="Введите URL страницы, например: https://example.com" />
        <button type="button" id="checkBtn" class="service-page__btn">Проверить</button>
    </div>
    <div id="results" class="service-page__results"></div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    var urlInput = document.getElementById('urlInput');
    var checkBtn = document.getElementById('checkBtn');
    var results = document.getElementById('results');

    checkBtn.addEventListener('click', async function() {
        var url = urlInput.value.trim();
        if (!url) { results.innerHTML = '<div class="meta-error">Пожалуйста, введите URL</div>'; return; }
        if (!url.startsWith('http://') && !url.startsWith('https://')) url = 'https://' + url;
        checkBtn.disabled = true;
        results.innerHTML = '<div class="service-page__loading"><svg width="40" height="40" viewBox="0 0 24 24" fill="none" stroke="#F36049" stroke-width="2"><path d="M21 12a9 9 0 1 1-6.219-8.56"/></svg><div>Измеряем скорость загрузки...</div></div>';
        try {
            const resp = await fetch('<?= htmlspecialchars($proxyUrl) ?>', {
                method: 'POST',
                headers: {'Content-Type': 'application/json'},
                body: JSON.stringify({url: url})
            });
            const data = await resp.json();
            if (data.success && data.data) { displayResults(data.data); }
            else { results.innerHTML = '<div class="meta-error">' + (data.error || 'Ошибка') + '</div>'; }
        } catch (e) {
            results.innerHTML = '<div class="meta-error">Ошибка соединения: ' + e.message + '</div>';
        } finally { checkBtn.disabled = false; }
    });

    urlInput.addEventListener('keypress', function(e) { if (e.key === 'Enter') checkBtn.click(); });

    function getRatingLabel(rating) {
        if (rating === 'good') return '<span style="color:#28a745;font-weight:600;">Хорошо</span>';
        if (rating === 'needs-improvement') return '<span style="color:#ffc107;font-weight:600;">Требует улучшения</span>';
        return '<span style="color:#dc3545;font-weight:600;">Плохо</span>';
    }

    function getRatingBg(rating) {
        if (rating === 'good') return '#d4edda';
        if (rating === 'needs-improvement') return '#fff3cd';
        return '#f8d7da';
    }

    function formatBytes(bytes) {
        if (bytes < 1024) return bytes + ' байт';
        if (bytes < 1024 * 1024) return (bytes / 1024).toFixed(1) + ' КБ';
        return (bytes / (1024 * 1024)).toFixed(2) + ' МБ';
    }

    function renderTag(name, value) {
        var isEmpty = !value || value === '—';
        return '<div class="meta-tag' + (isEmpty ? ' meta-tag--empty' : '') + '"><div class="meta-tag__name">' + name + '</div><div class="meta-tag__value">' + (value || '—') + '</div></div>';
    }

    function displayResults(data) {
        var metrics = data.metrics, resources = data.resources, renderBlocking = data.renderBlocking, serverInfo = data.serverInfo, recommendations = data.recommendations, statusCode = data.statusCode;
        var html = '<div class="meta-results">';

        html += '<div class="meta-section"><h3 class="meta-section__title">Статус ответа сервера</h3>';
        html += renderTag('HTTP Status Code', statusCode || '—');
        html += '</div>';

        if (metrics) {
            html += '<div class="meta-section"><h3 class="meta-section__title">Ключевые метрики</h3>';
            Object.keys(metrics).forEach(function(key) {
                var m = metrics[key];
                var label = m.label || key;
                var value = m.value !== undefined ? (key === 'pageSize' ? formatBytes(m.value) : m.value + ' мс') : '—';
                var ratingHtml = m.rating ? getRatingLabel(m.rating) : '';
                var bg = m.rating ? getRatingBg(m.rating) : '#fff';
                html += '<div class="meta-tag" style="background:' + bg + ';"><div class="meta-tag__name">' + label + '</div><div class="meta-tag__value">' + value + ' ' + ratingHtml + '</div></div>';
            });
            html += '</div>';
        }

        if (resources) {
            var blockingCount = renderBlocking && typeof renderBlocking === 'object'
                ? ((renderBlocking.scripts || 0) + (renderBlocking.styles || 0))
                : (renderBlocking || 0);
            html += '<div class="meta-section"><h3 class="meta-section__title">Ресурсы страницы</h3><div class="meta-stats">';
            if (resources.scripts !== undefined) html += '<div class="meta-stat"><span class="meta-stat__value">' + resources.scripts + '</span><span class="meta-stat__label">Скриптов</span></div>';
            if (resources.styles !== undefined) html += '<div class="meta-stat"><span class="meta-stat__value">' + resources.styles + '</span><span class="meta-stat__label">Стилей</span></div>';
            if (resources.images !== undefined) html += '<div class="meta-stat"><span class="meta-stat__value">' + resources.images + '</span><span class="meta-stat__label">Изображений</span></div>';
            html += '<div class="meta-stat"><span class="meta-stat__value">' + blockingCount + '</span><span class="meta-stat__label">Блокирующих</span></div>';
            html += '</div></div>';
        }

        if (serverInfo) {
            html += '<div class="meta-section"><h3 class="meta-section__title">Настройки сервера</h3>';
            html += renderTag('Сжатие (Gzip/Brotli)', serverInfo.compression ? 'Включено' : 'Отключено');
            if (serverInfo.server) html += renderTag('Сервер', serverInfo.server);
            html += '</div>';
        }

        if (recommendations && recommendations.length > 0) {
            html += '<div class="meta-section meta-section--recommendations"><h3 class="meta-section__title">Рекомендации по улучшению</h3><ul class="meta-recommendations">';
            recommendations.forEach(function(r) { html += '<li>' + r + '</li>'; });
            html += '</ul></div>';
        } else {
            html += '<div class="meta-section meta-section--success"><h3 class="meta-section__title">Отлично!</h3><p>Показатели скорости в норме. Сайт загружается быстро.</p></div>';
        }

        html += '</div>';
        results.innerHTML = html;
    }
});
</script>
<?php endif; ?>
