<?php
if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED !== true) die();
global $APPLICATION;
$APPLICATION->AddHeadString('<link rel="stylesheet" href="/local/modules/rechecker.tools/css/shared.css">');
$proxyUrl = $arResult['API_PROXY_URL'];
$apiKeySet = $arResult['API_KEY_SET'];
?>
<?php if (!$apiKeySet): ?>
    <div class="meta-error" style="padding:16px;background:#fef2f2;border-radius:8px;color:#dc2626;">API ключ не настроен. Укажите ключ в настройках модуля rechecker.tools.</div>
<?php else: ?>
<div class="service-page__form">
    <div class="service-page__input-group">
        <input type="text" id="urlInput" class="service-page__input" placeholder="https://example.com или example.com" />
        <button type="button" id="checkBtn" class="service-page__btn">Проверить</button>
    </div>
    <div id="results" class="service-page__results"></div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    var urlInput = document.getElementById('urlInput');
    var checkBtn = document.getElementById('checkBtn');
    var results = document.getElementById('results');

    checkBtn.addEventListener('click', async function() {
        var url = urlInput.value.trim();
        if (!url) { results.innerHTML = '<div class="meta-error">Пожалуйста, введите домен или URL</div>'; return; }
        if (!url.startsWith('http://') && !url.startsWith('https://')) url = 'https://' + url;
        checkBtn.disabled = true;
        results.innerHTML = '<div class="service-page__loading"><svg width="40" height="40" viewBox="0 0 24 24" fill="none" stroke="#F36049" stroke-width="2"><path d="M21 12a9 9 0 1 1-6.219-8.56"/></svg><div>Получаем данные WHOIS...</div></div>';
        try {
            const resp = await fetch('<?= htmlspecialchars($proxyUrl) ?>', {
                method: 'POST',
                headers: {'Content-Type': 'application/json'},
                body: JSON.stringify({url: url})
            });
            const data = await resp.json();
            if (data.success && data.data) { displayResults(data.data); }
            else { results.innerHTML = '<div class="meta-error">' + (data.error || 'Ошибка') + '</div>'; }
        } catch (e) {
            results.innerHTML = '<div class="meta-error">Ошибка соединения: ' + e.message + '</div>';
        } finally { checkBtn.disabled = false; }
    });

    urlInput.addEventListener('keypress', function(e) { if (e.key === 'Enter') checkBtn.click(); });

    function escHtml(str) {
        return String(str || '').replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;');
    }

    function renderTag(name, value) {
        var isEmpty = !value || value === '—';
        return '<div class="meta-tag' + (isEmpty ? ' meta-tag--empty' : '') + '"><div class="meta-tag__name">' + name + '</div><div class="meta-tag__value">' + (value || '—') + '</div></div>';
    }

    function formatDate(dateStr) {
        if (!dateStr) return '—';
        try {
            return new Date(dateStr).toLocaleDateString('ru-RU', {day:'2-digit', month:'2-digit', year:'numeric'});
        } catch(e) { return dateStr; }
    }

    function getExpiryColor(days) {
        if (days == null) return '#323036';
        if (days <= 30) return '#dc3545';
        if (days <= 90) return '#ffc107';
        return '#28a745';
    }

    function displayResults(data) {
        var domain = data.domain, whois = data.whois, dns = data.dns, ageDays = data.ageDays, ageYears = data.ageYears, daysUntilExpiry = data.daysUntilExpiry, recommendations = data.recommendations;
        var html = '<div class="meta-results">';

        if (domain) {
            html += '<div class="meta-section"><h3 class="meta-section__title">Домен</h3>';
            html += renderTag('Доменное имя', domain);
            html += '</div>';
        }

        html += '<div class="meta-section"><h3 class="meta-section__title">Возраст и срок действия</h3><div class="meta-stats">';
        html += '<div class="meta-stat"><span class="meta-stat__value">' + (ageDays != null ? ageDays : '—') + '</span><span class="meta-stat__label">Дней домену</span></div>';
        html += '<div class="meta-stat"><span class="meta-stat__value">' + (ageYears != null ? ageYears : '—') + '</span><span class="meta-stat__label">Лет домену</span></div>';
        var expiryColor = getExpiryColor(daysUntilExpiry);
        html += '<div class="meta-stat"><span class="meta-stat__value" style="color:' + expiryColor + '">' + (daysUntilExpiry != null ? daysUntilExpiry : '—') + '</span><span class="meta-stat__label">Дней до истечения</span></div>';
        html += '</div></div>';

        if (whois) {
            html += '<div class="meta-section"><h3 class="meta-section__title">Данные WHOIS</h3>';
            if (whois.creationDate) html += renderTag('Дата регистрации', formatDate(whois.creationDate));
            else html += renderTag('Дата регистрации', '—');
            if (whois.expirationDate) html += renderTag('Дата истечения', formatDate(whois.expirationDate));
            else html += renderTag('Дата истечения', '—');
            html += renderTag('Регистратор', whois.registrar || '—');
            if (whois.status && whois.status.length > 0) html += renderTag('Статус', whois.status.join(', '));
            if (whois.nameservers && whois.nameservers.length > 0) {
                html += '<div class="meta-tag"><div class="meta-tag__name">DNS-серверы (NS)</div>';
                whois.nameservers.forEach(function(ns) { html += '<div class="meta-tag__value" style="margin-bottom:4px;">' + escHtml(ns) + '</div>'; });
                html += '</div>';
            }
            html += '</div>';
        }

        if (dns && Object.keys(dns).length > 0) {
            html += '<div class="meta-section"><h3 class="meta-section__title">DNS информация</h3>';
            ['a','aaaa','mx','txt','ns'].forEach(function(key) {
                var val = dns[key];
                var displayVal = val && val.length ? (Array.isArray(val) ? val.join(', ') : String(val)) : '—';
                html += renderTag(key.toUpperCase(), displayVal);
            });
            html += '</div>';
        }

        if (recommendations && recommendations.length > 0) {
            html += '<div class="meta-section meta-section--recommendations"><h3 class="meta-section__title">Рекомендации</h3><ul class="meta-recommendations">';
            recommendations.forEach(function(r) { html += '<li>' + escHtml(r) + '</li>'; });
            html += '</ul></div>';
        } else {
            html += '<div class="meta-section meta-section--success"><h3 class="meta-section__title">Отлично!</h3><p>Домен в порядке. Не забывайте своевременно продлевать регистрацию.</p></div>';
        }

        html += '</div>';
        results.innerHTML = html;
    }
});
</script>
<?php endif; ?>
