<?php
if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED !== true) die();

use Bitrix\Main\Localization\Loc;
use Bitrix\Main\ModuleManager;

Loc::loadMessages(__FILE__);

class rechecker_tools extends CModule
{
    public $MODULE_ID = 'rechecker.tools';
    public $MODULE_VERSION;
    public $MODULE_VERSION_DATE;
    public $MODULE_NAME;
    public $MODULE_DESCRIPTION;
    public $MODULE_GROUP_RIGHTS = 'N';
    public $PARTNER_NAME;
    public $PARTNER_URI;

    public function __construct()
    {
        $this->MODULE_VERSION = '1.0.0';
        $this->MODULE_VERSION_DATE = '2025-01-01';
        $this->MODULE_NAME = 'reChecker Tools';
        $this->MODULE_DESCRIPTION = 'SEO-инструменты на базе reChecker API: проверка мета-тегов, SSL, редиректов, заголовков и других параметров сайта.';
        $this->PARTNER_NAME = 'Evaris';
        $this->PARTNER_URI = 'https://evaris.ru';
    }

    public function DoInstall()
    {
        global $APPLICATION;

        $this->InstallFiles();

        ModuleManager::RegisterModule($this->MODULE_ID);

        $APPLICATION->ThrowException('Модуль reChecker Tools успешно установлен.');
        return true;
    }

    public function DoUninstall()
    {
        global $APPLICATION;

        $this->UnInstallFiles();

        // Удаляем настройки модуля
        COption::RemoveOption($this->MODULE_ID);

        ModuleManager::UnRegisterModule($this->MODULE_ID);

        $APPLICATION->ThrowException('Модуль reChecker Tools удалён.');
        return true;
    }

    public function InstallFiles()
    {
        // Копируем компоненты
        $srcComponents = __DIR__ . '/../components';
        $dstComponents = $_SERVER['DOCUMENT_ROOT'] . '/local/components/rechecker.tools';

        if (is_dir($srcComponents)) {
            CopyDirFiles($srcComponents, $dstComponents, true, true);
        }

        return true;
    }

    public function UnInstallFiles()
    {
        // Удаляем компоненты
        $dstComponents = $_SERVER['DOCUMENT_ROOT'] . '/local/components/rechecker.tools';
        if (is_dir($dstComponents)) {
            DeleteDirFilesEx($dstComponents);
        }
        return true;
    }
}
