<?php
if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED !== true) die();
if (!CModule::IncludeModule('rechecker.tools')) die('Module not installed');

global $APPLICATION;

$MODULE_ID = 'rechecker.tools';
$RIGHT = $APPLICATION->GetGroupRight($MODULE_ID);
if ($RIGHT < 'W') $APPLICATION->AuthForm('');

// Сохранение настроек
if ($_SERVER['REQUEST_METHOD'] === 'POST' && check_bitrix_sessid()) {
    if ($RIGHT >= 'W') {
        $apiKey = trim($_POST['api_key'] ?? '');
        COption::SetOptionString($MODULE_ID, 'api_key', $apiKey);

        if ($apiKey) {
            $testResult = json_decode(rechecker_tools_curl_check('https://rechecker.ru/api/external/meta-tags', $apiKey, 'https://example.com'), true);
            if (isset($testResult['success']) && $testResult['success']) {
                CAdminMessage::ShowNote('API ключ успешно сохранён и проверен — соединение с rechecker.ru работает!');
            } else {
                $error = $testResult['error'] ?? 'Нет ответа от сервера';
                CAdminMessage::ShowError('Ключ сохранён, но проверка не прошла: ' . htmlspecialchars($error));
            }
        } else {
            CAdminMessage::ShowNote('Настройки сохранены. API ключ не задан — компоненты работать не будут.');
        }
    }
}

function rechecker_tools_curl_check(string $url, string $apiKey, string $testUrl): string
{
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_HTTPHEADER => ['Content-Type: application/json', 'X-API-Key: ' . $apiKey],
        CURLOPT_POSTFIELDS => json_encode(['url' => $testUrl]),
        CURLOPT_TIMEOUT => 15,
        CURLOPT_SSL_VERIFYPEER => true,
    ]);
    $result = curl_exec($ch);
    curl_close($ch);
    return $result ?: '{}';
}

$currentApiKey = COption::GetOptionString($MODULE_ID, 'api_key', '');
$keyIsSet = !empty($currentApiKey);

$tabControl = new CAdminTabControl('tabControl', [
    ['DIV' => 'tab1', 'TAB' => 'Настройки API',     'ICON' => '', 'TITLE' => 'Настройка API ключа reChecker'],
    ['DIV' => 'tab2', 'TAB' => 'Как это работает',  'ICON' => '', 'TITLE' => 'Архитектура и принцип работы модуля'],
    ['DIV' => 'tab3', 'TAB' => 'Использование',      'ICON' => '', 'TITLE' => 'Как подключать компоненты на страницы'],
]);

$tabControl->Begin();
?>

<form method="post" action="<?= $APPLICATION->GetCurPage() ?>?mid=<?= htmlspecialchars($MODULE_ID) ?>&lang=<?= LANGUAGE_ID ?>">
<?= bitrix_sessid_post() ?>

<?php $tabControl->BeginNextTab(); ?>

<tr>
    <td width="40%" class="adm-detail-valign-top">
        <b>API ключ reChecker</b><br><br>
        <small>Ключ хранится в настройках модуля и используется всеми компонентами автоматически — вводить его нигде больше не нужно.</small>
    </td>
    <td width="60%">
        <input type="text" name="api_key"
               value="<?= htmlspecialchars($currentApiKey) ?>"
               size="60"
               placeholder="sk_xxxxxxxxxxxxxxxxxxxxxxxx"
               style="font-family: monospace; width: 100%; max-width: 500px;">
        <br><br>
        <?php if ($keyIsSet): ?>
            <span style="color: #27ae60; font-weight: bold;">&#10003; Ключ задан</span>
        <?php else: ?>
            <span style="color: #e74c3c; font-weight: bold;">&#10007; Ключ не задан — компоненты не будут работать</span>
        <?php endif; ?>
    </td>
</tr>
<tr>
    <td colspan="2">
        <div style="background:#f0f7ff;border:1px solid #c3daf9;border-radius:4px;padding:16px;margin-top:8px;">
            <b>Где получить API ключ:</b>
            <ol style="margin:10px 0 0;padding-left:20px;line-height:1.8;">
                <li>Войдите в личный кабинет на <a href="https://rechecker.ru/profile" target="_blank" style="color:#2271b1;"><b>rechecker.ru/profile</b></a></li>
                <li>В разделе «API» нажмите «Сгенерировать ключ»</li>
                <li>Скопируйте ключ (начинается с <code>sk_</code>) и вставьте в поле выше</li>
                <li>Нажмите «Сохранить» — ключ будет автоматически проверен</li>
            </ol>
            <div style="margin-top:10px;padding-top:10px;border-top:1px solid #c3daf9;color:#555;font-size:12px;">
                Нет аккаунта? <a href="https://rechecker.ru" target="_blank">Зарегистрируйтесь на rechecker.ru</a>
            </div>
        </div>
    </td>
</tr>

<?php $tabControl->BeginNextTab(); ?>

<tr>
    <td colspan="2" style="padding:16px;">

        <div style="background:#fff8e1;border-left:4px solid #f59e0b;padding:12px 16px;border-radius:0 4px 4px 0;margin-bottom:20px;">
            <b>Кратко:</b> Модуль — это прослойка между вашим сайтом и API rechecker.ru. Он хранит API ключ централизованно и предоставляет готовые Bitrix-компоненты для каждого SEO-инструмента.
        </div>

        <h3 style="margin-top:0;">Схема работы</h3>
        <div style="background:#f5f5f5;border-radius:4px;padding:16px;font-family:monospace;font-size:13px;line-height:2;">
            Пользователь вводит URL<br>
            &nbsp;&nbsp;&darr;<br>
            Страница сайта (index.php) → <code>IncludeComponent('rechecker.tools:meta-tags')</code><br>
            &nbsp;&nbsp;&darr;<br>
            Компонент рендерит форму, JS делает POST на <code>proxy.php</code><br>
            &nbsp;&nbsp;&darr;<br>
            <code>proxy.php</code> загружает модуль → берёт API ключ из настроек → вызывает <code>ApiClient</code><br>
            &nbsp;&nbsp;&darr;<br>
            <code>ApiClient</code> делает запрос к <code>rechecker.ru/api/external/...</code><br>
            &nbsp;&nbsp;&darr;<br>
            Результат возвращается на страницу и отображается пользователю
        </div>

        <h3>Зачем proxy.php?</h3>
        <p>API ключ <b>никогда не попадает в браузер</b>. Все запросы к rechecker.ru идут с сервера через <code>proxy.php</code>, который авторизует запрос ключом из настроек модуля. Пользователь видит только результат.</p>

        <h3>Структура модуля</h3>
        <table class="adm-list-table" style="width:100%;">
            <tr class="adm-list-table-header">
                <td><b>Файл</b></td>
                <td><b>Назначение</b></td>
            </tr>
            <tr><td><code>local/modules/rechecker.tools/lib/ApiClient.php</code></td><td>PHP-клиент для rechecker.ru API. 9 методов: checkMetaTags, checkSsl, checkRedirects и т.д.</td></tr>
            <tr><td><code>local/modules/rechecker.tools/css/shared.css</code></td><td>Общие стили для отображения результатов всех компонентов</td></tr>
            <tr><td><code>local/components/rechecker.tools/{сервис}/component.php</code></td><td>Логика компонента: берёт параметры, передаёт в шаблон</td></tr>
            <tr><td><code>local/components/rechecker.tools/{сервис}/proxy.php</code></td><td>Серверный прокси: принимает POST от JS, возвращает JSON с результатом</td></tr>
            <tr><td><code>local/components/rechecker.tools/{сервис}/templates/.default/template.php</code></td><td>HTML + JS: форма ввода URL и отображение результатов</td></tr>
            <tr><td><code>servisy/{сервис}/index.php</code></td><td>Страница сервиса: заголовок, IncludeComponent, SEO-статья, FAQ, CTA</td></tr>
        </table>

        <h3>9 доступных сервисов</h3>
        <table class="adm-list-table" style="width:100%;">
            <tr class="adm-list-table-header">
                <td><b>Компонент</b></td>
                <td><b>Что проверяет</b></td>
                <td><b>Страница</b></td>
            </tr>
            <?php
            $services = [
                'meta-tags'    => ['Мета-теги (Title, Description, OG, H1/H2)', '/servisy/meta-tags/'],
                'ssl'          => ['SSL-сертификат (срок, протокол, оценка A+)', '/servisy/ssl/'],
                'redirects'    => ['Цепочка редиректов (301, 302, 307, 308)', '/servisy/redirects/'],
                'headers'      => ['HTTP заголовки безопасности (CSP, HSTS)', '/servisy/headers/'],
                'web-vitals'   => ['Скорость загрузки (TTFB, размер, ресурсы)', '/servisy/web-vitals/'],
                'broken-links' => ['Битые ссылки на странице (до 50 ссылок)', '/servisy/broken-links/'],
                'robots'       => ['Файл robots.txt (правила, sitemap)', '/servisy/robots/'],
                'sitemap'      => ['Sitemap.xml (количество URL, структура)', '/servisy/sitemap/'],
                'whois'        => ['WHOIS домена (регистратор, даты, NS)', '/servisy/whois/'],
            ];
            foreach ($services as $name => [$desc, $url]): ?>
            <tr>
                <td><code>rechecker.tools:<?= $name ?></code></td>
                <td><?= $desc ?></td>
                <td><a href="<?= $url ?>" target="_blank"><?= $url ?></a></td>
            </tr>
            <?php endforeach; ?>
        </table>

    </td>
</tr>

<?php $tabControl->BeginNextTab(); ?>

<tr>
    <td colspan="2" style="padding:16px;">

        <h3 style="margin-top:0;">Подключение компонента на страницу</h3>
        <p>Вставьте вызов компонента в любое место Bitrix-шаблона или страницы:</p>
        <pre style="background:#f5f5f5;padding:14px;border-radius:4px;font-size:13px;line-height:1.6;">&lt;?php $APPLICATION-&gt;IncludeComponent(
    'rechecker.tools:meta-tags', // название компонента
    '',                          // шаблон ('' = .default)
    [
        'SHOW_FAQ' =&gt; 'N',      // показывать FAQ секцию (Y/N)
        'SHOW_CTA' =&gt; 'N',      // показывать CTA секцию (Y/N)
    ]
); ?&gt;</pre>

        <div style="background:#f0fff4;border:1px solid #bbf7d0;border-radius:4px;padding:12px 16px;margin-bottom:20px;">
            <b>Примечание:</b> На страницах <code>/servisy/*/index.php</code> компоненты уже подключены. FAQ и CTA секции там встроены в саму страницу, поэтому передаётся <code>SHOW_FAQ =&gt; 'N'</code>.
        </div>

        <h3>Прямое использование ApiClient в PHP</h3>
        <p>Если нужно обращаться к API из своего кода (без компонента):</p>
        <pre style="background:#f5f5f5;padding:14px;border-radius:4px;font-size:13px;line-height:1.6;">&lt;?php
// Обязательно подключить модуль перед использованием
CModule::IncludeModule('rechecker.tools');

// Создать клиент — ключ берётся автоматически из настроек модуля
$client = new \Rechecker\Tools\ApiClient();

// Проверки:
$result = $client-&gt;checkMetaTags('https://example.com');
$result = $client-&gt;checkSsl('https://example.com');
$result = $client-&gt;checkRedirects('https://example.com');
$result = $client-&gt;checkHeaders('https://example.com');
$result = $client-&gt;checkWebVitals('https://example.com');
$result = $client-&gt;checkBrokenLinks('https://example.com', 50);
$result = $client-&gt;checkRobots('https://example.com');
$result = $client-&gt;checkSitemap('https://example.com');
$result = $client-&gt;checkWhois('https://example.com');

// Все методы возвращают массив:
// ['success' => true, 'data' => [...]]  — успех
// ['success' => false, 'error' => '...'] — ошибка
?&gt;</pre>

        <h3>Что делать если не работает</h3>
        <table class="adm-list-table" style="width:100%;">
            <tr class="adm-list-table-header">
                <td><b>Проблема</b></td>
                <td><b>Решение</b></td>
            </tr>
            <tr><td>«API ключ не настроен»</td><td>Вернитесь на вкладку «Настройки API» и введите ключ</td></tr>
            <tr><td>Форма есть, но результаты не появляются</td><td>Откройте DevTools → Network → проверьте ответ от <code>proxy.php</code></td></tr>
            <tr><td>Модуль не подключается</td><td>Убедитесь что модуль установлен: Bitrix → Marketplace → Установленные модули</td></tr>
            <tr><td>Ошибка «Неверный ключ» при сохранении</td><td>Скопируйте ключ заново из <a href="https://rechecker.ru/profile" target="_blank">rechecker.ru/profile</a> — убедитесь что нет пробелов</td></tr>
            <tr><td>proxy.php возвращает 404</td><td>Компоненты должны быть в <code>/local/components/rechecker.tools/</code> — переустановите модуль</td></tr>
        </table>

    </td>
</tr>

<?php
$tabControl->Buttons();
?>
<input type="submit" name="save" value="Сохранить" class="adm-btn-save">
<?php
$tabControl->End();
?>
</form>
